/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser.DisplayPort;

import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortDirection;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortHotPlugMessage;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortMessage;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortPreambleMessage;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortReplyMessage;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortRequestMessage;
import com.quantumdata.busmon.parser.TypeConverter;
import java.util.StringTokenizer;

public class DisplayPortDataBlock
extends DataBlock {
    private static final int PARSING_STATE_NATIVE_GET_REQUEST_COMMAND = 1;
    private static final int PARSING_STATE_NATIVE_GET_REQUEST_ADDRESS = 2;
    private static final int PARSING_STATE_NATIVE_GET_REQUEST_LENGTH = 3;
    private static final int PARSING_STATE_NATIVE_GET_REQUEST_WRITE_BYTES = 4;
    private static final int PARSING_STATE_I2C_GET_REQUEST_COMMAND = 5;
    private static final int PARSING_STATE_I2C_GET_REQUEST_ADDRESS = 6;
    private static final int PARSING_STATE_I2C_GET_REQUEST_LENGTH = 7;
    private static final int PARSING_STATE_I2C_GET_REQUEST_WRITE_BYTES = 8;
    private static final int PARSING_STATE_I2C_GET_REPLY_COMMAND = 13;
    private static final int PARSING_STATE_GET_REPLY_BYTES = 14;
    private static final byte NATIVE_READ = -112;
    private static final byte NATIVE_WRITE = -128;
    private static final byte I2C_OVER_AUX_REQUEST_MOT_MASK = 64;
    private static final byte I2C_OVER_AUX_REQUEST_MOT = 64;
    private static final byte I2C_OVER_AUX_REQUEST_MASK = 48;
    private static final byte I2C_OVER_AUX_REQUEST_WRITE = 0;
    private static final byte I2C_OVER_AUX_REQUEST_READ = 16;
    private static final byte I2C_OVER_AUX_REQUEST_STATUS_UPDATE_REQUEST = 32;
    private static final byte AUX_ACK = 0;
    private static final byte AUX_NACK = 16;
    private static final byte AUX_DEFER = 32;
    private static final byte I2C_NACK = 64;
    private static final byte I2C_DEFER = -128;
    protected static DisplayPortDataBlock sLastBlock = null;
    protected static DisplayPortDataBlock sLastHotPlugBlock = null;
    private int parsingState;
    protected long aTimestamp;
    protected long aPreviousBlockTimestamp;
    protected String aParsedMessageDetails;
    protected int aSourceID;
    protected DisplayPortDirection aDirection;
    protected DisplayPortMessage aMessage;
    protected Integer[] aRawPacket;
    private static int[] sVH = new int[5];

    public DisplayPortDataBlock(Integer[] integerArray) {
        this.aRawPacket = (Integer[])integerArray.clone();
        this.aSourceID = integerArray[7];
        this.aDirection = integerArray[8] == 1 ? DisplayPortDirection.REQUEST : DisplayPortDirection.REPLY;
        this.aTimestamp = TypeConverter.composeLong(integerArray, 9);
        this.aPreviousBlockTimestamp = sLastBlock == null ? 0L : sLastBlock.getTimestamp();
        this.aMessage = null;
        this.parse(integerArray);
        if (this.aMessage != null) {
            this.aParsedMessageDetails = this.aMessage.getDetails();
            if (this.aMessage.getMessageType() != 13) {
                sLastBlock = this;
            }
            if (this.aMessage.getMessageType() == 12) {
                sLastHotPlugBlock = this;
            }
        }
    }

    public String getHexRepresentation(Integer[] integerArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (integerArray != null && integerArray.length != 0) {
            int n;
            int n2;
            stringBuffer.append(String.format("Length: %d bytes\n\n", integerArray.length));
            stringBuffer.append("Addr  Data Bytes (Hex)           ASCII Representation\n");
            boolean bl = false;
            for (n2 = 0; n2 < integerArray.length; ++n2) {
                Integer n3 = integerArray[n2];
                if (n2 % 8 == 0) {
                    bl = true;
                }
                if (bl && n2 != 0) {
                    for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                        stringBuffer2.append("   ");
                        stringBuffer3.append("  ");
                    }
                    if (stringBuffer2 != null) {
                        stringBuffer.append(stringBuffer2);
                    }
                    if (stringBuffer3 != null) {
                        stringBuffer.append(" | ");
                        stringBuffer.append(stringBuffer3);
                    }
                    stringBuffer.append('\n');
                    stringBuffer2 = new StringBuffer();
                    stringBuffer3 = new StringBuffer();
                }
                if (bl) {
                    stringBuffer.append(String.format("%04X  ", n2));
                    for (n = 0; n < n2 % 8; ++n) {
                        stringBuffer2.append("   ");
                        stringBuffer3.append("  ");
                    }
                    bl = false;
                }
                stringBuffer2.append(String.format("%02X ", n3));
                if (n3 > 32 && n3 < 127) {
                    stringBuffer3.append(String.format("%c ", n3));
                    continue;
                }
                stringBuffer3.append(". ");
            }
            for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                stringBuffer2.append("   ");
                stringBuffer3.append("  ");
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer3 != null) {
                stringBuffer.append(" | ");
                stringBuffer.append(stringBuffer3);
            }
        } else {
            stringBuffer.append("No datablock contents.");
        }
        return stringBuffer.toString();
    }

    private void parse(Integer[] integerArray) {
        if (this.aDirection == DisplayPortDirection.REQUEST) {
            this.parseRequest(integerArray);
        } else {
            this.parseReply(integerArray);
        }
    }

    private void parseRequest(Integer[] integerArray) {
        if ((integerArray[13] & 0x80) == 128) {
            this.parseNativeRequest(integerArray);
        } else {
            this.parseNonNativeRequest(integerArray);
        }
    }

    private void parseReply(Integer[] integerArray) {
        if ((integerArray[13] & 0xF) == 2) {
            this.parseHotPlug(integerArray);
        } else if ((integerArray[13] & 0xF) == 1) {
            this.parsePreamble(integerArray);
        } else {
            this.parseAuxReply(integerArray);
        }
    }

    private void parsePreamble(Integer[] integerArray) {
        int n = TypeConverter.IntegerArrayToInt(integerArray, 14);
        this.aMessage = new DisplayPortPreambleMessage(13, n);
    }

    private void parseHotPlug(Integer[] integerArray) {
        if (integerArray[14] == 2) {
            this.aMessage = new DisplayPortHotPlugMessage(12, DisplayPortHotPlugMessage.DisplayPortHotPlugType.FALLING_EDGE);
        } else if (integerArray[14] == 1) {
            this.aMessage = new DisplayPortHotPlugMessage(12, DisplayPortHotPlugMessage.DisplayPortHotPlugType.RISING_EDGE);
        }
    }

    public String getDetails() {
        return this.aParsedMessageDetails;
    }

    public String getSummary() {
        if (this.aMessage != null) {
            return this.aMessage.getSummary();
        }
        return "";
    }

    public String getType() {
        if (this.aMessage != null) {
            return this.aMessage.getMessageTypeText();
        }
        return "UNDEFINED";
    }

    public boolean isError() {
        if (this.aMessage != null) {
            return this.aMessage.isError();
        }
        return false;
    }

    private void parseNativeRequest(Integer[] integerArray) {
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.parsingState = 1;
        block6: for (int i = 13; i < integerArray.length; ++i) {
            int n4 = integerArray[i];
            switch (this.parsingState) {
                case 1: {
                    by = (byte)(n4 & 0xF0);
                    if (by == -112) {
                        n3 = 1;
                    } else if (by == -128) {
                        n3 = 2;
                    }
                    by2 = (byte)(n4 & 0xF);
                    this.parsingState = 2;
                    continue block6;
                }
                case 2: {
                    if (!bl) {
                        by3 = (byte)n4;
                        bl = true;
                        this.parsingState = 2;
                        continue block6;
                    }
                    by4 = (byte)n4;
                    this.parsingState = 3;
                    continue block6;
                }
                case 3: {
                    int n5;
                    n2 = n4 + 1;
                    if (n3 == 1) {
                        n5 = DisplayPortDataBlock.convertAddress(by2, by3, by4);
                        this.aMessage = new DisplayPortRequestMessage(n3, n5, n2, null, false);
                        continue block6;
                    }
                    if (n3 != 2) continue block6;
                    byArray = new byte[n2];
                    n = 0;
                    this.parsingState = 4;
                    continue block6;
                }
                case 4: {
                    byArray[n] = (byte)n4;
                    if (++n < n2) {
                        this.parsingState = 4;
                        continue block6;
                    }
                    int n5 = DisplayPortDataBlock.convertAddress(by2, by3, by4);
                    this.aMessage = new DisplayPortRequestMessage(n3, n5, n2, byArray, false);
                }
            }
        }
    }

    private void parseNonNativeRequest(Integer[] integerArray) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        boolean bl2 = false;
        int n4 = 0;
        this.parsingState = 5;
        block6: for (int i = 13; i < integerArray.length; ++i) {
            int n5 = integerArray[i];
            switch (this.parsingState) {
                case 5: {
                    if ((n5 & 0x30) == 0) {
                        n4 = 3;
                    } else if ((n5 & 0x30) == 16) {
                        n4 = 4;
                    } else if ((n5 & 0x30) == 32) {
                        n4 = 5;
                    }
                    if ((n5 & 0x40) == 64) {
                        bl2 = true;
                    }
                    this.parsingState = 6;
                    continue block6;
                }
                case 6: {
                    if (!bl) {
                        bl = true;
                        this.parsingState = 6;
                        continue block6;
                    }
                    n = n5;
                    if (i == integerArray.length - 1) {
                        this.aMessage = new DisplayPortRequestMessage(n4, n, 0, null, bl2);
                        continue block6;
                    }
                    this.parsingState = 7;
                    continue block6;
                }
                case 7: {
                    n2 = n5 + 1;
                    if (n4 == 4) {
                        this.aMessage = new DisplayPortRequestMessage(n4, n, n2, null, bl2);
                        continue block6;
                    }
                    if (n4 != 3) continue block6;
                    byArray = new byte[n2];
                    n3 = 0;
                    this.parsingState = 8;
                    continue block6;
                }
                case 8: {
                    byArray[n3] = (byte)n5;
                    if (++n3 < n2) {
                        this.parsingState = 8;
                        continue block6;
                    }
                    this.aMessage = new DisplayPortRequestMessage(n4, n, n2, byArray, bl2);
                }
            }
        }
    }

    private void parseAuxReply(Integer[] integerArray) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = null;
        int n3 = 0;
        this.parsingState = 13;
        block11: for (int i = 13; i < integerArray.length; ++i) {
            int n4 = integerArray[i];
            switch (this.parsingState) {
                case 13: {
                    byte by = (byte)(n4 & 0xFF);
                    switch (by) {
                        case 0: {
                            if (DisplayPortDataBlock.wasLastBlockNative()) {
                                n3 = 6;
                                break;
                            }
                            n3 = 9;
                            break;
                        }
                        case 16: {
                            n3 = 7;
                            break;
                        }
                        case 32: {
                            n3 = 8;
                            break;
                        }
                        case 64: {
                            n3 = 10;
                            break;
                        }
                        case -128: {
                            n3 = 11;
                        }
                    }
                    if (i == integerArray.length - 1) {
                        this.aMessage = new DisplayPortReplyMessage(n3, null);
                        continue block11;
                    }
                    n = 0;
                    n2 = integerArray.length - 1 - i;
                    byArray = new byte[n2];
                    this.parsingState = 14;
                    continue block11;
                }
                case 14: {
                    byArray[n] = (byte)n4;
                    if (++n == n2) {
                        this.aMessage = new DisplayPortReplyMessage(n3, byArray);
                        continue block11;
                    }
                    this.parsingState = 14;
                }
            }
        }
    }

    public static void resetParser() {
        sLastBlock = null;
    }

    public boolean isNative() {
        if (this.aMessage == null) {
            return false;
        }
        int n = this.aMessage.getMessageType();
        if (n == 1) {
            return true;
        }
        return n == 2;
    }

    private static boolean wasLastBlockNative() {
        if (sLastBlock != null) {
            return sLastBlock.isNative();
        }
        return false;
    }

    public Integer[] getRawMessage() {
        return this.aRawPacket;
    }

    public int getSourceID() {
        return this.aSourceID;
    }

    public long getTimestamp() {
        return this.aTimestamp;
    }

    private static int convertAddress(byte by, byte by2, byte by3) {
        int n = 0;
        n |= (by & 0xF) << 16;
        n |= (by2 & 0xFF) << 8;
        return n |= by3 & 0xFF;
    }

    public static String getDataValueAsHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        String string2 = string.length() == 1 ? "0x0" : "0x";
        String string3 = string2 + string;
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n2 = 14 - string3.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static int lastBlockAddress() {
        DisplayPortMessage displayPortMessage;
        int n = 0;
        if (sLastBlock != null && (displayPortMessage = DisplayPortDataBlock.sLastBlock.aMessage) != null) {
            n = displayPortMessage.getAddress();
        }
        return n;
    }

    static String getContentData(int n, byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                stringBuffer.append("DPCD_REV: " + (by >> 4 & 0xF) + "." + (by & 0xF) + "\n");
                break;
            }
            case 1: 
            case 256: 
            case 537: {
                if (n == 1) {
                    stringBuffer.append("MAX_LINK_RATE:  ");
                } else if (n == 256) {
                    stringBuffer.append("LINK_BW_SET:  ");
                } else {
                    stringBuffer.append("TEST_LINK_RATE:  ");
                }
                if (by == 6) {
                    stringBuffer.append("1.62Gbps");
                } else if (by == 10) {
                    stringBuffer.append("2.7Gbps");
                } else {
                    stringBuffer.append("Undefined Value - Data '" + by + "'");
                }
                if (n != 537 && (by == 6 || by == 10)) {
                    stringBuffer.append(" per lane");
                }
                stringBuffer.append("\n");
                break;
            }
            case 2: 
            case 257: 
            case 544: {
                if (n == 2) {
                    stringBuffer.append("MAXIMUM_LANE_COUNT:  ");
                } else if (n == 257) {
                    stringBuffer.append("LANE_COUNT_SET:  ");
                } else {
                    stringBuffer.append("TEST_LANE_COUNT:  ");
                }
                if ((by & 0xF) == 1) {
                    stringBuffer.append("One Lane (Lane0)\n");
                } else if ((by & 0xF) == 2) {
                    stringBuffer.append("Two Lanes (Lane0, Lane1)\n");
                } else if ((by & 0xF) == 4) {
                    stringBuffer.append("Four Lanes (Lane0, Lane1, Lane2, Lane3)\n");
                } else {
                    stringBuffer.append("Undefined Value - Data '" + by + "'\n");
                }
                if (n == 544) break;
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    ENHANCED_FRAME_CAP:  Enhanced Framing Symbol Sequence is Enabled\n");
                    break;
                }
                stringBuffer.append("    ENHANCED_FRAME_CAP:  Enhanced Framing Symbol Sequence is NOT Enabled\n");
                break;
            }
            case 3: {
                stringBuffer.append("MAX_DOWNSPREAD:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    MAX_DOWNSPREAD:  0.5% down spread\n");
                } else {
                    stringBuffer.append("    MAX_DOWNSPREAD:  No down spread\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    NO_AUX_HANDSHAKE_LINK_TRAINING:  No AUX Handshake Required\n");
                    break;
                }
                stringBuffer.append("    NO_AUX_HANDSHAKE_LINK_TRAINING:  An AUX Handshake Required to Synchronize DisplayPort Transmitter\n");
                break;
            }
            case 4: {
                if ((by & 1) == 1) {
                    stringBuffer.append("NORP:  Set\n");
                    break;
                }
                stringBuffer.append("NORP:  NOT set\n");
                break;
            }
            case 5: {
                if ((by & 1) == 1) {
                    stringBuffer.append("DWN_STRM_PORT_PRESENT:  This Device Has a Downstream Port\n");
                    if ((by & 6) == 6) {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  Others\n");
                    } else if ((by & 6) == 4) {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  DVI or HDMI\n");
                    } else if ((by & 6) == 2) {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  Analog VGA or Analog Video over DVI-I\n");
                    } else {
                        stringBuffer.append("    DWN_STRM_PORT_TYPE:  DisplayPort\n");
                    }
                    if ((by & 8) == 8) {
                        stringBuffer.append("    FORMAT_CONVERSION:  This downstream port has a format conversion block\n");
                        break;
                    }
                    stringBuffer.append("    FORMAT_CONVERSION:  This Branch Device does not have a format conversion block\n");
                    break;
                }
                stringBuffer.append("DWN_STRM_PORT_PRESENT:  This Device Has No Downstream Port\n");
                break;
            }
            case 6: {
                if ((by & 1) == 1) {
                    stringBuffer.append("MAIN_LINK_CHANNEL_CODING:  DisplayPort Receiver Supports Main Link Channel Coding\n");
                    break;
                }
                stringBuffer.append("MAIN_LINK_CHANNEL_CODING:  DisplayPort Receiver Does NOT Support Main Link Channel Coding\n");
                break;
            }
            case 7: {
                stringBuffer.append("DOWNSTREAM_PORT_COUNT:\n");
                int n4 = by & 0xF;
                stringBuffer.append("    DWN_STRM_PORT_COUNT:  '" + n4 + "'\n");
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    OUI:  Supported\n");
                    break;
                }
                stringBuffer.append("    OUI:  NOT Supported\n");
                break;
            }
            case 8: 
            case 10: {
                if (n == 8) {
                    stringBuffer.append("RECEIVE_PORT0_CAP_0:  '" + by + "'\n");
                } else {
                    stringBuffer.append("RECEIVE_PORT1_CAP_0:  '" + by + "'\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    LOCAL_EDID_PRESENT:  This receiver port has a local EDID\n");
                } else {
                    stringBuffer.append("    LOCAL_EDID_PRESENT:  This receiver port does not have a local EDID\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    ASSOCIATED_TO_PRECEDING_PORT:  This port is used for secondary isochronous stream\n");
                    break;
                }
                stringBuffer.append("    ASSOCIATED_TO_PRECEDING_PORT:  This port is used for main isochronous stream\n");
                break;
            }
            case 9: 
            case 11: {
                int n5 = by & 0xFF;
                if (n == 9) {
                    stringBuffer.append("RECEIVE_PORT0_CAP_1:  '" + by + "'\n");
                } else {
                    stringBuffer.append("RECEIVE_PORT1_CAP_1:  '" + by + "'\n");
                }
                int n6 = (n5 + 1) * 32;
                stringBuffer.append("    Buffer Size:  '" + n6 + "'\n");
                break;
            }
            case 258: {
                stringBuffer.append("TRAINING_PATTERN_SET:\n");
                if ((by & 3) == 0) {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  Training not in progress (or disabled)\n");
                } else if ((by & 3) == 1) {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  Training Pattern 1\n");
                } else if ((by & 3) == 2) {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  Training Pattern 2\n");
                } else {
                    stringBuffer.append("    TRAINING_PATTERN_SET:  RESERVED\n");
                }
                if ((by & 0xC) == 0) {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  Link Quality Test Pattern Not Transmitted\n");
                } else if ((by & 0xC) == 4) {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  D10.2 Test Pattern (unscrambled) Transmitted\n");
                } else if ((by & 0xC) == 8) {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  Symbol Error Rate Measurement Pattern Transmitted\n");
                } else {
                    stringBuffer.append("    LINK_QUAL_PATTERN_SET:  PRBS7 Transmitted\n");
                }
                if ((by & 0x10) == 16) {
                    stringBuffer.append("    RECOVERED_CLOCK_OUT_EN:  Enabled\n");
                } else {
                    stringBuffer.append("    RECOVERED_CLOCK_OUT_EN:  Not Enabled\n");
                }
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    SCRAMBLING_DISABLE:  Scrambler Disabled\n");
                } else {
                    stringBuffer.append("    SCRAMBLING_DISABLE:  Data Scrambled Before Transmission\n");
                }
                if ((by & 0xC0) == 0) {
                    stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Disparity Error and Illegal Symbol Error\n");
                    break;
                }
                if ((by & 0xC0) == 64) {
                    stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Disparity Error\n");
                    break;
                }
                if ((by & 0xC0) == 128) {
                    stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Illegal Symbol Error\n");
                    break;
                }
                stringBuffer.append("    SYMBOL_ERROR_COUNT_SEL:  Reserved");
                break;
            }
            case 259: 
            case 260: 
            case 261: 
            case 262: {
                int n7 = n - 259;
                int n8 = by & 3;
                stringBuffer.append("TRAINING_LANE" + n7 + "_SET\n");
                stringBuffer.append("    VOLTAGE_SWING_SET:  Training Pattern 1 With Voltage Swing Level " + n8 + "\n");
                if ((by & 4) == 4) {
                    stringBuffer.append("    MAX_SWING_REACHED:  Maximum Driven Current Setting Is Reached\n");
                } else {
                    stringBuffer.append("    MAX_SWING_REACHED:  Maximum Driven Current Setting Is NOT Reached\n");
                }
                int n9 = (by & 0x18) / 8;
                if (n9 == 0) {
                    stringBuffer.append("    PRE-EMPHASIS_SET:  Training Pattern 2 without pre-emphasis\n");
                } else {
                    stringBuffer.append("    PRE-EMPHASIS_SET:  Training Pattern 2 with pre-emphasis level " + n9 + "\n");
                }
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    MAX_PRE-EMPHASIS_REACHED:  Maximum Drive Current Setting Is Reached\n");
                    break;
                }
                stringBuffer.append("    MAX_PRE-EMPHASIS_REACHED:  Maximum Drive Current Setting Is NOT Reached\n");
                break;
            }
            case 263: {
                stringBuffer.append("DOWNSPREAD_CTRL:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    MODULATION_FREQ:  33 kHz\n");
                } else {
                    stringBuffer.append("    MODULATION_FREQ:  30 kHz\n");
                }
                if ((by & 0x10) == 16) {
                    stringBuffer.append("    SPREAD_AMP:  0.5% down spread\n");
                    break;
                }
                stringBuffer.append("    SPREAD_AMP:  0.0% down spread\n");
                break;
            }
            case 264: {
                if ((by & 1) == 1) {
                    stringBuffer.append("MAIN_LINK_CHANNEL_CODING_SET:  SET_ANSI 8B10B\n");
                    break;
                }
                stringBuffer.append("MAIN_LINK_CHANNEL_CODING_SET:  Not Selected\n");
                break;
            }
            case 512: {
                stringBuffer.append("SINK_COUNT:\n");
                int n10 = by & 0x3F;
                stringBuffer.append("    SINK_COUNT:  " + n10 + "\n");
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    CP_READY:  All Sink Devices Are CP-Capable\n");
                    break;
                }
                stringBuffer.append("    CP_READY:  At Least One Sink Device Is NOT CP-Capable\n");
                break;
            }
            case 513: {
                stringBuffer.append("DEVICE_SERVICE_IRQ_VECTOR:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    REMOTE_CONTROL_COMMAND_PENDING:  Command Is Pending\n");
                } else {
                    stringBuffer.append("    REMOTE_CONTROL_COMMAND_PENDING:  No Command Pending\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    AUTOMATED_TEST_REQUEST:  Must Read Addresses 00218h-0027Fh for Requested Link Test\n");
                } else {
                    stringBuffer.append("    AUTOMATED_TEST_REQUEST:  No Automated Test Request Pending\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    CP_IRQ:  Set\n");
                } else {
                    stringBuffer.append("    CP_IRQ:  Not Set\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    SINK_SPECIFIC_IRQ:  Set\n");
                    break;
                }
                stringBuffer.append("    SINK_SPECIFIC_IRQ:  Not Set\n");
                break;
            }
            case 514: 
            case 515: {
                n2 = 0;
                n3 = 1;
                if (n == 515) {
                    n2 = 2;
                    n3 = 3;
                }
                stringBuffer.append("LANE" + n2 + "_" + n3 + "_STATUS:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    LANE" + n2 + "_CR_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n2 + "_CR_DONE:  Cleared\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    LANE" + n2 + "_CHANNEL_EQ_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n2 + "_CHANNEL_EQ_DONE:  Cleared\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    LANE" + n2 + "_SYMBOL_LOCKED:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n2 + "_SYMBOL_LOCKED:  Cleared\n");
                }
                if ((by & 0x10) == 16) {
                    stringBuffer.append("    LANE" + n3 + "_CR_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n3 + "_CR_DONE:  Cleared\n");
                }
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    LANE" + n3 + "_CHANNEL_EQ_DONE:  Set\n");
                } else {
                    stringBuffer.append("    LANE" + n3 + "_CHANNEL_EQ_DONE:  Cleared\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    LANE" + n3 + "_SYMBOL_LOCKED:  Set\n");
                    break;
                }
                stringBuffer.append("    LANE" + n3 + "_SYMBOL_LOCKED:  Cleared\n");
                break;
            }
            case 516: {
                stringBuffer.append("LANE_ALIGN__STATUS_UPDATED:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    INTERLANE_ALIGN_DONE:  Set\n");
                } else {
                    stringBuffer.append("    INTERLANE_ALIGN_DONE:  Cleared\n");
                }
                if ((by & 0x40) == 64) {
                    stringBuffer.append("    DOWNSTREAM_PORT_STATUS_CHANGED:  Set\n");
                } else {
                    stringBuffer.append("    DOWNSTREAM_PORT_STATUS_CHANGED:  Cleared\n");
                }
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    LINK_STATUS_UPDATED:  Set\n");
                    break;
                }
                stringBuffer.append("    LINK_STATUS_UPDATED:  Cleared\n");
                break;
            }
            case 517: {
                stringBuffer.append("SINK_STATUS:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    RECEIVE_PORT_0_STATUS:  Sink in synchronization\n");
                } else {
                    stringBuffer.append("    RECEIVE_PORT_0_STATUS:  Sink out of synchronization\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    RECEIVE_PORT_1_STATUS:  Sink in synchronization\n");
                    break;
                }
                stringBuffer.append("    RECEIVE_PORT_1_STATUS:  Sink out of synchronization\n");
                break;
            }
            case 518: 
            case 519: {
                n2 = 0;
                n3 = 1;
                if (n == 519) {
                    n2 = 2;
                    n3 = 3;
                }
                stringBuffer.append("ADJUST_REQUEST_LANE" + n2 + "_" + n3 + ":\n");
                int n11 = by & 3;
                int n12 = (by & 0xC) / 4;
                stringBuffer.append("    VOLTAGE_SWING_LANE_" + n2 + ":  " + n11 + "\n");
                stringBuffer.append("    PRE-EMPHASIS_LANE_" + n2 + ":  " + n12 + "\n");
                n11 = (by & 0x30) / 16;
                n12 = (by & 0xC0) / 64;
                stringBuffer.append("    VOLTAGE_SWING_LANE_" + n3 + ":  " + n11 + "\n");
                stringBuffer.append("    PRE-EMPHASIS_LANE_" + n3 + ":  " + n12 + "\n");
                break;
            }
            case 528: 
            case 529: 
            case 530: 
            case 531: 
            case 532: 
            case 533: 
            case 534: 
            case 535: {
                int n13 = 0;
                if (n == 530 || n == 531) {
                    n13 = 1;
                } else if (n == 532 || n == 533) {
                    n13 = 2;
                } else if (n == 534 || n == 535) {
                    n13 = 3;
                }
                stringBuffer.append("SYMBOL_ERROR_COUNT_LANE" + n13 + "\n");
                if (n % 2 == 0) {
                    stringBuffer.append("    ERROR_COUNT_BITS7-0:  " + by + "\n");
                    break;
                }
                stringBuffer.append("    ERROR_COUNT_BITS14-8:  " + by + "\n");
                if ((by & 0x80) == 128) {
                    stringBuffer.append("    ERROR_COUNT_VALID:  Set\n");
                    break;
                }
                stringBuffer.append("    ERROR_COUNT_VALID:  Cleared\n");
                break;
            }
            case 536: {
                stringBuffer.append("TEST_REQUEST:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_LINK_TRAINING:  Link Training Test Requested\n");
                } else {
                    stringBuffer.append("    TEST_LINK_TRAINING:  No Link Training Test Requested\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    TEST_PATTERN:  Test Pattern Requested\n");
                } else {
                    stringBuffer.append("    TEST_PATTERN:  No Test Pattern Requested\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    TEST_EDID_READ:  EDID Read Test Requested\n");
                } else {
                    stringBuffer.append("    TEST_EDID_READ:  No EDID Read Test Requested\n");
                }
                if ((by & 8) == 8) {
                    stringBuffer.append("    PHY_TEST_PATTERN:  PHY Test Pattern Requested\n");
                    break;
                }
                stringBuffer.append("    PHY_TEST_PATTERN:  No Request for PHY Test Pattern\n");
                break;
            }
            case 545: {
                stringBuffer.append("TEST_PATTERN:  " + by + " - ");
                if (by == 1) {
                    stringBuffer.append("color ramps\n");
                    break;
                }
                if (by == 2) {
                    stringBuffer.append("black and white vertical lines\n");
                    break;
                }
                if (by == 3) {
                    stringBuffer.append("color square\n");
                    break;
                }
                stringBuffer.append("Undefined Value\n");
                break;
            }
            case 546: 
            case 547: 
            case 548: 
            case 549: {
                if (n == 546 || n == 547) {
                    stringBuffer.append("TEST_H_TOTAL:  ");
                } else {
                    stringBuffer.append("TEST_V_TOTAL:  ");
                }
                if (n % 2 == 0) {
                    stringBuffer.append("Bits 15-8:  " + by + "\n");
                    break;
                }
                stringBuffer.append("Bits 7-0:  " + by + "\n");
                break;
            }
            case 550: 
            case 551: 
            case 552: 
            case 553: {
                if (n == 550 || n == 551) {
                    stringBuffer.append("TEST_H_START:  ");
                } else {
                    stringBuffer.append("TEST_V_START:  ");
                }
                if (n % 2 == 0) {
                    stringBuffer.append("Bits 15-8:  " + by + "\n");
                    break;
                }
                stringBuffer.append("Bits 7-0:  " + by + "\n");
                break;
            }
            case 554: 
            case 555: 
            case 556: 
            case 557: {
                String string = "H";
                if (n == 556 || n == 557) {
                    string = "V";
                }
                stringBuffer.append("TEST_" + string + "SYNC:\n");
                if (n % 2 == 0) {
                    if ((by & 0x80) == 128) {
                        stringBuffer.append("    TEST_" + string + "SYNC_POLARITY:  Set\n");
                    } else {
                        stringBuffer.append("    TEST_" + string + "SYNC_POLARITY:  Cleared\n");
                    }
                    int n14 = by & 0x7F;
                    stringBuffer.append("    TEST_" + string + "SYNC_WIDTH Bits 14-8:  " + n14 + "\n");
                    break;
                }
                int n15 = by & 0xFF;
                stringBuffer.append("    TEST_" + string + "SYNC_WIDTH Bits 7-0:  " + n15 + "\n");
                break;
            }
            case 558: 
            case 559: 
            case 560: 
            case 561: {
                String string = "H_WIDTH";
                if (n == 560 || n == 561) {
                    string = "V_HEIGHT";
                }
                stringBuffer.append("TEST_" + string + ":\n");
                if (n % 2 == 0) {
                    stringBuffer.append("    TEST_" + string + " Bits 15-8:  " + by + "\n");
                    break;
                }
                stringBuffer.append("    TEST_" + string + " Bits 7-0:  " + by + "\n");
                break;
            }
            case 562: {
                stringBuffer.append("TEST_MISC:\n");
                String string = "S";
                if ((by & 1) == 0) {
                    string = "As";
                }
                stringBuffer.append("    TEST_SYNCHRONOUS_CLOCK:  Link Clock and Stream Clock " + string + "\n");
                if ((by & 6) == 0) {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  RGB\n");
                } else if ((by & 6) == 2) {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  YCbCr 4:2:2\n");
                } else if ((by & 6) == 4) {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  YCbCr 4:4:4\n");
                } else {
                    stringBuffer.append("    TEST_COLOR_FORMAT:  Reserved\n");
                }
                String string2 = "VESA range (from 0 to maximum)";
                if ((by & 8) == 8) {
                    string2 = "CEA range (as defined in CEA-861C Section 5)";
                }
                stringBuffer.append("    TEST_DYNAMIC_RANGE:  " + string2 + "\n");
                String string3 = "ITU601";
                if ((by & 0x10) == 16) {
                    string3 = "ITU709";
                }
                stringBuffer.append("    TEST_YCBCR_COEFFICIENTS:  " + string3 + "\n");
                int n16 = (by & 0xE0) / 64;
                int n17 = 6 + n16 * 2;
                if (n16 == 4) {
                    n17 += 2;
                }
                if (n16 >= 5) {
                    stringBuffer.append("    TEST_BIT_DEPTH:  Reserved\n");
                } else {
                    stringBuffer.append("    TEST_BIT_DEPTH:  " + n17 + " bits\n");
                }
                stringBuffer.append("    TEST_BIT_DEPTH:  \n");
                break;
            }
            case 563: {
                stringBuffer.append("TEST_MISC:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_REFRESH_DENOMINATOR:  1.001\n");
                } else {
                    stringBuffer.append("    TEST_REFRESH_DENOMINATOR:  1\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    TEST_INTERLACED:  Interlaced\n");
                    break;
                }
                stringBuffer.append("    TEST_INTERLACED:  Non-Interlaced\n");
                break;
            }
            case 564: {
                stringBuffer.append("TEST_REFRESH_RATE_NUMERATOR:  " + by + "\n");
                stringBuffer.append("    Refresh Rate = TEST_REFRESH_RATE_NUMERATOR / TEST_REFRESH_RATE_DENOMINATOR\n");
                break;
            }
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: {
                String string = "R_Cr";
                if (n == 578 || n == 579) {
                    string = "G_Y";
                } else if (n == 580 || n == 581) {
                    string = "B_Cb";
                }
                stringBuffer.append("TEST_CRC_" + string + ":\n");
                if (n % 2 == 0) {
                    stringBuffer.append("    CRC Value Bits  7-0:  " + String.format("%1$02X", by) + "\n");
                    break;
                }
                stringBuffer.append("    CRC Value Bits 15-8:  " + String.format("%1$02X", by) + "\n");
                break;
            }
            case 582: {
                stringBuffer.append("TEST_SYNC_MISC:\n");
                int n18 = by & 0xF;
                stringBuffer.append("    TEST_CRC_COUNT:  " + n18 + "\n");
                if ((by & 0x20) == 32) {
                    stringBuffer.append("    TEST_CRC_SUPPORTED:  CRC Supported By Sink Device\n");
                    break;
                }
                stringBuffer.append("    TEST_CRC_SUPPORTED:  CRC NOT Supported By Sink Device\n");
                break;
            }
            case 584: {
                stringBuffer.append("PHY_TEST_PATTERN:\n");
                if ((by & 3) == 0) {
                    stringBuffer.append("    PHY_TEST_PATTERN_SEL:  No Test Pattern Selected\n");
                    break;
                }
                if ((by & 3) == 1) {
                    stringBuffer.append("    PHY_TEST_PATTERN_SEL:  D10.2 Without Scrambling\n");
                    break;
                }
                if ((by & 3) == 2) {
                    stringBuffer.append("    PHY_TEST_PATTERN_SEL:  Symbol Error Measurement Count\n");
                    break;
                }
                stringBuffer.append("    PHY_TEST_PATTERN_SEL:  PRBS7\n");
                break;
            }
            case 608: {
                stringBuffer.append("TEST_RESPONSE:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_ACK:  Positive ACK of TEST_REQ\n");
                } else {
                    stringBuffer.append("    TEST_ACK:  Writing 0 has no effect on TEST_REQ state\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    TEST_NAK:  Negative ACK of TEST_REQ\n");
                } else {
                    stringBuffer.append("    TEST_NAK:  Writing 0 has no effect on TEST_REQ state\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    TEST_EDID_CHECKSUM_WRITE:  EDID Checksum has been Written to TEST_EDID_CHECKSUM\n");
                    break;
                }
                stringBuffer.append("    TEST_EDID_CHECKSUM_WRITE:  No Write to TEST_EDID_CHECKSUM\n");
                break;
            }
            case 609: {
                stringBuffer.append("TEST_EDID_CHECKSUM:  " + by + "\n");
                break;
            }
            case 624: {
                stringBuffer.append("TEST_SINK:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    TEST_SINK_START:  Start Calculating CRC on the Next Frame\n");
                    break;
                }
                stringBuffer.append("    TEST_SINK_START:  Stop Calculating CRC on the Next Frame\n");
                break;
            }
            case 768: {
                stringBuffer.append("SOURCE_IEEE_OUI 7-0:  " + by + "\n");
                break;
            }
            case 769: {
                stringBuffer.append("SOURCE_IEEE_OUI 15-8:  " + by + "\n");
                break;
            }
            case 770: {
                stringBuffer.append("SOURCE_IEEE_OUI 23-16:  " + by + "\n");
                break;
            }
            case 1024: {
                stringBuffer.append("SINK_IEEE_OUI 7-0:  " + by + "\n");
                break;
            }
            case 1025: {
                stringBuffer.append("SINK_IEEE_OUI 15-8:  " + by + "\n");
                break;
            }
            case 1026: {
                stringBuffer.append("SINK_IEEE_OUI 23-16:  " + by + "\n");
                break;
            }
            case 1280: {
                stringBuffer.append("BRANCH_IEEE_OUI 7-0:  " + by + "\n");
                break;
            }
            case 1281: {
                stringBuffer.append("BRANCH_IEEE_OUI 15-8:  " + by + "\n");
                break;
            }
            case 1282: {
                stringBuffer.append("BRANCH_IEEE_OUI 23-16:  " + by + "\n");
                break;
            }
            case 1536: {
                stringBuffer.append("SET_POWER:\n");
                if ((by & 3) == 1) {
                    stringBuffer.append("    SET_POWER_STATE:  Set Local Sink and all downstream sinks to D0 (normal operation mode)\n");
                    break;
                }
                if ((by & 3) == 2) {
                    stringBuffer.append("    SET_POWER_STATE:  Set Local Sink and all downstream sinks to D3 (power down mode)\n");
                    break;
                }
                stringBuffer.append("    SET_POWER_STATE:  RESERVED\n");
            }
        }
        return stringBuffer.toString();
    }

    private static int computeKSVFifoOffset(int n) {
        return (n - 426028) % 5;
    }

    private static int computeKSVFifoDeviceNumber(int n) {
        return (n - 426028) / 5 + 1;
    }

    static String getHDCPData(int n, byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        switch (n) {
            case 425984: 
            case 425985: 
            case 425986: 
            case 425987: 
            case 425988: {
                stringBuffer.append("Address: " + DisplayPortDataBlock.longAddressToHexString(n) + "\n");
                stringBuffer.append("Bksv Byte #" + (n - 425984 + 1));
                stringBuffer.append(": " + DisplayPortDataBlock.longAddressToHexString(by) + "\n");
                break;
            }
            case 425989: 
            case 425990: {
                stringBuffer.append("R0' Address " + DisplayPortDataBlock.longAddressToHexString(n) + ":  Value = " + DisplayPortDataBlock.longAddressToHexString(by) + "\n");
                break;
            }
            case 425991: 
            case 425992: 
            case 425993: 
            case 425994: 
            case 425995: {
                stringBuffer.append("Address: " + DisplayPortDataBlock.longAddressToHexString(n) + "\n");
                stringBuffer.append("Aksv Byte #" + (n - 425991 + 1));
                stringBuffer.append(": " + DisplayPortDataBlock.longAddressToHexString(by) + "\n");
                break;
            }
            case 425996: 
            case 425997: 
            case 425998: 
            case 425999: 
            case 426000: 
            case 426001: 
            case 426002: 
            case 426003: {
                int n2 = 8 * (n - 425996);
                stringBuffer.append("An:\n");
                stringBuffer.append("    SESSION_RANDOM_NUMBER Bits " + (n2 + 7) + "-" + n2 + ":  " + DisplayPortDataBlock.longAddressToHexString(by) + "\n");
                break;
            }
            case 426004: 
            case 426005: 
            case 426006: 
            case 426007: 
            case 426008: 
            case 426009: 
            case 426010: 
            case 426011: 
            case 426012: 
            case 426013: 
            case 426014: 
            case 426015: 
            case 426016: 
            case 426017: 
            case 426018: 
            case 426019: 
            case 426020: 
            case 426021: 
            case 426022: 
            case 426023: {
                int n3 = (n - 426004) / 4;
                int n4 = 8 * (n % 4);
                if (n4 == 0) {
                    DisplayPortDataBlock.sVH[n3] = 0;
                }
                int n5 = n3;
                sVH[n5] = sVH[n5] | by << n4;
                stringBuffer.append("V'.H" + n3 + " Address " + DisplayPortDataBlock.longAddressToHexString(n) + ":  Value = " + DisplayPortDataBlock.longAddressToHexString(sVH[n3]) + "\n");
                break;
            }
            case 426024: {
                stringBuffer.append("Bcaps:\n");
                if ((by & 2) == 2) {
                    stringBuffer.append("    HDCP_REPEATER_CAPABILITY:  Yes\n");
                } else {
                    stringBuffer.append("    HDCP_REPEATER_CAPABILITY:  No\n");
                }
                if ((by & 1) == 1) {
                    stringBuffer.append("    HDCP_CAPABLE:  Yes\n");
                    break;
                }
                stringBuffer.append("    HDCP_CAPABLE:  No\n");
                break;
            }
            case 426025: {
                stringBuffer.append("Bstatus:\n");
                if ((by & 1) == 1) {
                    stringBuffer.append("    READY:  This HDCP Receiver Built Attached KSV List and Computed Verification Value\n");
                } else {
                    stringBuffer.append("    READY:  KSV List Not Computed or Verified\n");
                }
                if ((by & 2) == 2) {
                    stringBuffer.append("    RO'_AVAILABLE:  R0' is Available for Reading at HDCP Receiver\n");
                } else {
                    stringBuffer.append("    RO'_AVAILABLE:  R0' is NOT Available for Reading at HDCP Receiver\n");
                }
                if ((by & 4) == 4) {
                    stringBuffer.append("    LINK_INTEGRITY_FAILURE:  Loss of Cipher Synchronization Detected\n");
                    break;
                }
                stringBuffer.append("    LINK_INTEGRITY_FAILURE:  No Loss of Cipher Synchronization Detected\n");
                break;
            }
            case 426026: {
                stringBuffer.append("Binfo:\n");
                int n6 = by & 0x7F;
                boolean bl = (by & 0x80) == 128;
                stringBuffer.append("    DEVICE_COUNT:  " + n6 + "\n");
                stringBuffer.append("    MAX_DEVS_EXCEEDED:  " + bl + "\n");
                break;
            }
            case 426027: {
                stringBuffer.append("Binfo:\n");
                int n7 = by & 7;
                boolean bl = (by & 8) == 8;
                stringBuffer.append("    DEPTH:  " + n7 + " Levels\n");
                stringBuffer.append("    MAX_CASCADE_EXCEEDED:  " + bl + "\n");
                break;
            }
            case 426028: 
            case 426029: 
            case 426030: 
            case 426031: 
            case 426032: 
            case 426033: 
            case 426034: 
            case 426035: 
            case 426036: 
            case 426037: 
            case 426038: 
            case 426039: 
            case 426040: 
            case 426041: 
            case 426042: {
                int n8 = DisplayPortDataBlock.computeKSVFifoDeviceNumber(n);
                int n9 = DisplayPortDataBlock.computeKSVFifoOffset(n);
                int n10 = 5 * n8 + n9;
                stringBuffer.append("KSV Fifo Address " + DisplayPortDataBlock.longAddressToHexString(n) + ":  Value = " + DisplayPortDataBlock.longAddressToHexString(by) + ", Offset = " + n10 + "\n");
                break;
            }
            case 426176: 
            case 426177: 
            case 426178: 
            case 426179: 
            case 426180: 
            case 426181: 
            case 426182: 
            case 426183: 
            case 426184: 
            case 426185: 
            case 426186: 
            case 426187: 
            case 426188: 
            case 426189: 
            case 426190: 
            case 426191: 
            case 426192: 
            case 426193: 
            case 426194: 
            case 426195: 
            case 426196: 
            case 426197: 
            case 426198: 
            case 426199: 
            case 426200: 
            case 426201: 
            case 426202: 
            case 426203: 
            case 426204: 
            case 426205: 
            case 426206: 
            case 426207: 
            case 426208: 
            case 426209: 
            case 426210: 
            case 426211: 
            case 426212: 
            case 426213: 
            case 426214: 
            case 426215: 
            case 426216: 
            case 426217: 
            case 426218: 
            case 426219: 
            case 426220: 
            case 426221: 
            case 426222: 
            case 426223: 
            case 426224: 
            case 426225: 
            case 426226: 
            case 426227: 
            case 426228: 
            case 426229: 
            case 426230: 
            case 426231: 
            case 426232: 
            case 426233: 
            case 426234: 
            case 426235: 
            case 426236: 
            case 426237: 
            case 426238: 
            case 426239: {
                stringBuffer.append("DEBUG_REGISTER " + DisplayPortDataBlock.longAddressToHexString(n) + ":  Data Value is '" + DisplayPortDataBlock.longAddressToHexString(by) + "'\n");
            }
        }
        return stringBuffer.toString();
    }

    static String longAddressToHexString(int n) {
        String string = String.format("0x%1$X", n);
        return string;
    }

    private static String longAddressToHexString(byte by) {
        String string = String.format("0x%1$02X", by);
        return string;
    }

    public static boolean addressBlockIsReserved(int n) {
        if (n >= 12 && n <= 127) {
            return true;
        }
        if (n >= 144 && n <= 255) {
            return true;
        }
        if (n >= 265 && n <= 511) {
            return true;
        }
        if (n >= 524 && n <= 527) {
            return true;
        }
        if (n >= 565 && n <= 575) {
            return true;
        }
        if (n == 583) {
            return true;
        }
        if (n >= 585 && n <= 607) {
            return true;
        }
        if (n >= 610 && n <= 623) {
            return true;
        }
        if (n >= 625 && n <= 767) {
            return true;
        }
        if (n >= 771 && n <= 1023) {
            return true;
        }
        if (n >= 1027 && n <= 1279) {
            return true;
        }
        if (n >= 1283 && n <= 1535) {
            return true;
        }
        if (n >= 1537 && n <= 1791) {
            return true;
        }
        if (n >= 1792 && n <= 425983) {
            return true;
        }
        if (n >= 430080 && n <= 458751) {
            return true;
        }
        if (n >= 458752 && n <= 524287) {
            return true;
        }
        return n >= 426043 && n <= 426175;
    }

    static boolean addressIsHDCPBlock(int n) {
        return n >= 425984 && n <= 430079;
    }

    static boolean addressIsLT(int n) {
        return n >= 256 && n <= 264 || n >= 514 && n <= 519;
    }

    public static void printWithIndent(String string) {
        DisplayPortDataBlock.printWithIndent(string, 2);
    }

    public static void printWithIndent(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < n; ++i) {
                System.out.print(" ");
            }
            System.out.println(string2);
        }
    }

    public static Integer[] getWorkingMessage() {
        Integer[] integerArray = null;
        if (sLastBlock != null) {
            integerArray = DisplayPortDataBlock.sLastBlock.aRawPacket;
        }
        return integerArray;
    }

    public String getDirection() {
        if (this.aMessage != null) {
            return this.aMessage.getDirection();
        }
        return "";
    }

    public short getSource() {
        return 6;
    }

    public String getSourceName() {
        return "";
    }

    public boolean isEvent() {
        if (this.aMessage == null) {
            return false;
        }
        return this.aMessage.isEvent();
    }

    public boolean isI2C() {
        if (this.aMessage == null) {
            return false;
        }
        return this.aMessage.isI2C();
    }

    public boolean isCEC() {
        return false;
    }

    public boolean isHDCP() {
        if (this.aMessage == null) {
            return false;
        }
        return this.aMessage.isHDCP();
    }

    public boolean isDDCCI() {
        if (this.aMessage == null) {
            return false;
        }
        return this.aMessage.isDDCCI();
    }

    public boolean isEDID() {
        if (this.aMessage == null) {
            return false;
        }
        return this.aMessage.isEDID();
    }

    public boolean isLT() {
        if (this.aMessage == null) {
            return false;
        }
        return this.aMessage.isLT();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DisplayPortCommandType {
        UNDEFINED,
        READ,
        WRITE,
        UPDATE,
        AUX_DEFER,
        AUX_ACK,
        AUX_NACK,
        I2C_DEFER,
        I2C_ACK,
        I2C_NACK,
        HOTPLUG,
        PREAMBLE;

    }
}

